// AnimModel.cpp: implementation of the CAnimModel class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CharAnim.h"
#include "AnimModel.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAnimModel::CAnimModel()
{
   m_type = MODEL;
   m_glTexture = NULL;
}

CAnimModel::~CAnimModel()
{
   if( m_glTexture!=NULL ) delete [] m_glTexture;
}


//////////////////////////////////////////////////////////////////////
// Implementation
//////////////////////////////////////////////////////////////////////

BOOL CAnimModel::LoadModel(LPCTSTR szFilename)
{
   ASSERT(AfxIsValidString(szFilename));
   if( m_model.Load(szFilename) == TRUE ) {
      m_sModelFilename = szFilename;
      return TRUE;
   }
   else
      return FALSE;
};

BOOL CAnimModel::LoadTexturePCX(LPCTSTR szFilename)
{
   ASSERT(AfxIsValidString(szFilename));
   // Load the PCX file
   CXPCX pcx;
   if( pcx.Load(szFilename)!=0 ) return FALSE;
   // Set some global attributes
   m_iWidth = pcx.GetWidth();
   m_iHeight = pcx.GetHeight();

	// Now we need to scale it to be used in OpenGL
   GLubyte *unScaled;
	unScaled = new GLubyte[m_iWidth * m_iHeight * 4];
   if( unScaled==NULL ) return FALSE;
   // First we need to create a RGB bitmap
	LPBYTE palette = pcx.GetPalettePtr();
   LPBYTE pixel_buffer = pcx.GetBitmapPtr();
   for (int j = 0; j < m_iHeight; j++) {
		for (int i = 0; i < m_iWidth; i++) {
			unScaled[4*(j * m_iWidth + i)+0] = (GLubyte) palette[3*pixel_buffer[j*m_iWidth+i]+0];
			unScaled[4*(j * m_iWidth + i)+1] = (GLubyte) palette[3*pixel_buffer[j*m_iWidth+i]+1];
			unScaled[4*(j * m_iWidth + i)+2] = (GLubyte) palette[3*pixel_buffer[j*m_iWidth+i]+2];
			unScaled[4*(j * m_iWidth + i)+3] = (GLubyte) 255;
		}
	}
   // Then we need to figure out the dimension of
   // the new opengl buffer
	m_iScaledWidth = 1;
   while( m_iScaledWidth < m_iWidth ) m_iScaledWidth *=2;
	m_iScaledHeight = 1;
   while( m_iScaledHeight < m_iHeight ) m_iScaledHeight *=2;
   // Delete any previous attempt
   if (m_glTexture != NULL) {
		delete [] m_glTexture;
		m_glTexture = NULL;
	}
   // Create and scale the bitmap
	m_glTexture = new GLubyte[m_iScaledWidth * m_iScaledHeight * 4];
   if( m_glTexture==NULL ) return FALSE;
	gluScaleImage(GL_RGBA, m_iWidth, m_iHeight, GL_UNSIGNED_BYTE, unScaled, m_iScaledWidth, m_iScaledHeight, GL_UNSIGNED_BYTE, m_glTexture);
	delete [] unScaled;
	
   // Set texture flags
   glTexImage2D(GL_TEXTURE_2D, 0, 4, m_iScaledWidth, m_iScaledHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, m_glTexture);

   m_sTextureFilename = szFilename;
   return TRUE;
}


//////////////////////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////////////////////

BOOL CAnimModel::Render( TRenderDef &cfg )
{
	int i;
   int frame = 1;

   if( m_CoordArray==NULL ) GetFrame(cfg);

   glPushMatrix();

	glRotatef(-m_rot[0], 0.0f, 1.0f, 0.0f);
	glRotatef( m_rot[1], 0.0f, 0.0f, 1.0f);
   glRotatef(-m_rot[2], 1.0f, 0.0f, 0.0f);
   glTranslatef(-m_trans[2], -m_trans[0], m_trans[1]);
   
   if( cfg.CurrentView!=VIEW_SELECT ) {
      // Set the render color
      if( (cfg.CurrentView==VIEW_OBJECT) && IsSelected() ) 
         glColor3f(1.0, 1.0, 1.0);
      else
         glColor3f(m_colorR, m_colorG, m_colorB);
	   // Init before rendering
      int idx;
      float fWidth = (float)m_iWidth;
	   float fHeight = (float)m_iHeight;
      // Do render
      for( i=0; i < m_model.NumberOfTriangles(); i++ ) {
		   glBegin(GL_TRIANGLES);

		   glTexCoord2f((m_model.m_index_list[i].a_s)/fWidth, 
                      (m_model.m_index_list[i].a_t)/fHeight);
         idx = m_model.m_index_list[i].a;
         glVertex3f(m_CoordArray[idx].x,
                    m_CoordArray[idx].y,
                    m_CoordArray[idx].z);

		   glTexCoord2f((m_model.m_index_list[i].b_s)/fWidth, 
                      (m_model.m_index_list[i].b_t)/fHeight);
         idx = m_model.m_index_list[i].b;
         glVertex3f(m_CoordArray[idx].x,
                    m_CoordArray[idx].y,
                    m_CoordArray[idx].z);

		   glTexCoord2f((m_model.m_index_list[i].c_s)/fWidth, 
                      (m_model.m_index_list[i].c_t)/fHeight);
         idx = m_model.m_index_list[i].c;
         glVertex3f(m_CoordArray[idx].x,
                    m_CoordArray[idx].y,
                    m_CoordArray[idx].z);

		   glEnd();
	   }
   }

   // We may wanna draw some edge-dots too
   switch( cfg.CurrentView ) {
   case VIEW_VERTEX:
      glColor3f(1.0, 1.0, 1.0);
  	   glBegin(GL_POINTS);
      for( i=0; i < m_model.NumberOfVertices(); i++ ) {
         if( m_SelectArray[i] ) {
            glVertex3f(m_CoordArray[i].x,
				   	     m_CoordArray[i].y,
					        m_CoordArray[i].z);
         };
      };
  	   glEnd();
      break;
   case VIEW_SELECT:    
      for( i=0; i < m_model.NumberOfVertices(); i++ ) {
   		glPassThrough((GLfloat)i);
    	   glBegin(GL_POINTS);
         glVertex3f(m_CoordArray[i].x,
   		   	     m_CoordArray[i].y,
				        m_CoordArray[i].z);
     	   glEnd();
      };
      break;
   };

	glPopMatrix();
   return TRUE;
};

BOOL CAnimModel::UpdateMatrix(TOOLMODE action, TRenderDef &cfg )
{
   switch( cfg.CurrentView ) {
   case VIEW_OBJECT:
      if( !IsSelected() ) return TRUE; // only selected objects update
      CAnimObject::UpdateMatrix(action,cfg);
      break;
   case VIEW_VERTEX:
      UpdateVertexMatrix(action,cfg);
      break;
   default:
      // Not a supported view
      return FALSE;
   };
   return TRUE;
};

BOOL CAnimModel::GetFrame(TRenderDef &cfg)
{
   if( m_CoordArray==NULL ) {
      m_CoordArray = new tCoord[ NumberOfVertices() ];
      if( m_CoordArray==NULL ) return FALSE; // error: out of memory
   };
   ::CopyMemory( m_CoordArray, m_model.m_frame_list[cfg.frame].vertex, sizeof(tCoord)*NumberOfVertices() );
   if( m_SelectArray==NULL ) {
      m_SelectArray = new BOOL[ NumberOfVertices() ];
      if( m_SelectArray==NULL ) return FALSE; // error: out of memory
      for( int i=0; i<NumberOfVertices(); i++ ) m_SelectArray[i]=FALSE;
   };
   return TRUE;
};

BOOL CAnimModel::SetFrame()
{
   return TRUE;
};
