// AnimFigure.cpp: implementation of the CAnimFigure class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CharAnim.h"
#include "AnimFigure.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAnimFigure::CAnimFigure()
{
   m_type = FIGURE;
   m_TmpCoordArray = NULL;
}

CAnimFigure::~CAnimFigure()
{
   if( m_TmpCoordArray!=NULL ) delete m_TmpCoordArray;
   m_TmpCoordArray = NULL;
}

//////////////////////////////////////////////////////////////////////
// Overrides

BOOL CAnimFigure::Render( TRenderDef &cfg )
{
   if( cfg.CurrentView==VIEW_BONES ) {
      return m_bones.Render(cfg);
   };

	int i;
   if( m_CoordArray==NULL ) GetFrame(cfg);

   glPushMatrix();

   // Set base orientation and position
   glTranslatef(m_bones.m_Skeleton.trans[0], 
                m_bones.m_Skeleton.trans[1], 
                m_bones.m_Skeleton.trans[2]);

   glRotatef(m_bones.m_Skeleton.rot[2], 0.0f, 0.0f, 1.0f);
   glRotatef(m_bones.m_Skeleton.rot[1], 0.0f, 1.0f, 0.0f);
   glRotatef(m_bones.m_Skeleton.rot[0], 1.0f, 0.0f, 0.0f); 

   ::CopyMemory( m_CoordArray, m_model.m_frame_list[cfg.frame].vertex, sizeof(tCoord)*NumberOfVertices() );
   ::CopyMemory( m_TmpCoordArray, m_model.m_frame_list[cfg.frame].vertex, sizeof(tCoord)*NumberOfVertices() );

   DeformBone(m_bones.m_Skeleton.children,
			m_TmpCoordArray,
			m_CoordArray);

   if( cfg.CurrentView!=VIEW_SELECT ) {
      // Set the render color
      if( (cfg.CurrentView==VIEW_OBJECT) && IsSelected() ) 
         glColor3f(1.0, 1.0, 1.0);
      else
         glColor3f(m_colorR, m_colorG, m_colorB);
	   // Init before rendering
      int idx;
      float fWidth = (float)m_iWidth;
	   float fHeight = (float)m_iHeight;
      // Do render
      for( i=0; i < m_model.NumberOfTriangles(); i++ ) {
		   glBegin(GL_TRIANGLES);

		   glTexCoord2f((m_model.m_index_list[i].a_s)/fWidth, 
                      (m_model.m_index_list[i].a_t)/fHeight);
         idx = m_model.m_index_list[i].a;
         glVertex3f(m_CoordArray[idx].x,
                    m_CoordArray[idx].y,
                    m_CoordArray[idx].z);

		   glTexCoord2f((m_model.m_index_list[i].b_s)/fWidth, 
                      (m_model.m_index_list[i].b_t)/fHeight);
         idx = m_model.m_index_list[i].b;
         glVertex3f(m_CoordArray[idx].x,
                    m_CoordArray[idx].y,
                    m_CoordArray[idx].z);

		   glTexCoord2f((m_model.m_index_list[i].c_s)/fWidth, 
                      (m_model.m_index_list[i].c_t)/fHeight);
         idx = m_model.m_index_list[i].c;
         glVertex3f(m_CoordArray[idx].x,
                    m_CoordArray[idx].y,
                    m_CoordArray[idx].z);

		   glEnd();
	   }
   };

   // We may wanna draw some edge-dots too
   switch( cfg.CurrentView ) {
   case VIEW_VERTEX:
      glColor3f(1.0, 1.0, 1.0);
  	   glBegin(GL_POINTS);
      for( i=0; i < m_model.NumberOfVertices(); i++ ) {
         if( m_SelectArray[i] ) {
            glVertex3f(m_CoordArray[i].x,
				   	     m_CoordArray[i].y,
					        m_CoordArray[i].z);
         };
      };
  	   glEnd();
      break;
   case VIEW_SELECT:    
      for( i=0; i < m_model.NumberOfVertices(); i++ ) {
   		glPassThrough((GLfloat)i);
    	   glBegin(GL_POINTS);
         glVertex3f(m_CoordArray[i].x,
   		   	     m_CoordArray[i].y,
				        m_CoordArray[i].z);
     	   glEnd();
      };
      break;
   };

	glPopMatrix();
   return TRUE;
};


BOOL CAnimFigure::UpdateMatrix(TOOLMODE action, TRenderDef &cfg )
{
   if( cfg.CurrentView!=VIEW_BONES )
   {
      VectorCopy( m_bones.m_Skeleton.rot, m_rot );
      VectorCopy( m_bones.m_Skeleton.trans, m_trans );
      CAnimModel::UpdateMatrix(action,cfg);
      VectorCopy( m_rot, m_bones.m_Skeleton.rot );
      VectorCopy( m_trans, m_bones.m_Skeleton.trans );
      return TRUE;
   }
   else
      return m_bones.UpdateMatrix(action,cfg);
};

BOOL CAnimFigure::Select( CDC *dc, SELECTMODE mode, TRenderDef &cfg, CRect &rc )
{
   if( cfg.CurrentView!=VIEW_BONES )
      return CAnimModel::Select(dc,mode,cfg,rc);
   else {
      switch( mode ) {
      case SEL_ADD_ALL:
      case SEL_REMOVE_ALL:
         m_bones.m_SelectedBoneId = -1;
         break;
      case SEL_ADD:
         long dist;
         long coord;
         dist = m_bones.GetNearestVertex(dc,
                                         cfg,
                                         CPoint(rc.left,rc.top), 
                                         &coord );
         if( coord!=-1 ) {
            m_bones.m_SelectedBoneId = coord;
            // Attempt to update statusbar with new selection   
            tBone *pBone = m_bones.GetSelectedBone();
            if( pBone==NULL ) return FALSE;
            // Update statusbar text
            CMainFrm *pFrame = (CMainFrm *)AfxGetMainWnd();
            if( pFrame!=NULL ) pFrame->SetStatusText(pBone->Name);
         };
         break;
      };
   };
   return TRUE;
};

BOOL CAnimFigure::GetFrame(TRenderDef &cfg)
{
   CAnimModel::GetFrame(cfg);
   if( m_TmpCoordArray==NULL ) {
      m_TmpCoordArray = new tCoord[ NumberOfVertices() ];
      if( m_TmpCoordArray==NULL ) return FALSE; // error: out of memory
   };
   return TRUE;
};

BOOL CAnimFigure::SetFrame()
{
   return TRUE;
};

void CAnimFigure::DeformBone(tBone *pBone, tCoord *meshdata, tCoord *defdata)
// Deform mesh according to bone matrix
{
   ASSERT(meshdata);
   ASSERT(defdata);
   float weight;
   tVector pre, post;

   if( pBone==NULL ) return;
	// For every vertex in my deformable mesh
	for( int loop=0; loop < m_model.NumberOfVertices(); loop++ ) {
		// Get the weight
		weight = pBone->CV_weight[loop];
      if( weight > 0.0f )	{	// We only care if it is > 0
			// Offset the rotational center about that bones center
			pre[0] = meshdata[loop].x - pBone->trans[0];
			pre[1] = meshdata[loop].y - pBone->trans[1];
			pre[2] = meshdata[loop].z - pBone->trans[2];
			// Put it through the rotation
			KfxMultVectorByMatrix(pBone->matrix, pre, post);
			// Add in the weighted delta of this position
			defdata[loop].x += ((post[0] - meshdata[loop].x) * weight);
			defdata[loop].y += ((post[1] - meshdata[loop].y) * weight);
			defdata[loop].z += ((post[2] - meshdata[loop].z) * weight);
		}
	}

   // Check if this bone has children, if so recursive call
	DeformBone(pBone->children, meshdata, defdata);
   // Check if this bone has brothers, if so recursive call
	DeformBone(pBone->brothers, meshdata, defdata);
}

void CAnimFigure::AssignVertextToBone(int idBone)
{
   ASSERT(idBone>=0);
   AssignVertextToBone(idBone,&m_bones.m_Skeleton);
};

void CAnimFigure::AssignVertextToBone(LPCTSTR szBone)
{
   ASSERT(AfxIsValidString(szBone));
   tBone *pBone = m_bones.FindBone(CString(szBone),&m_bones.m_Skeleton);
   ASSERT(pBone);
   if( pBone==NULL ) return;
   AssignVertextToBone(pBone->Id,&m_bones.m_Skeleton);
};

void CAnimFigure::AssignVertextToBone(int idBone, tBone *pBone)
// The actual function the recursively assign selected vertices to
// a bone
// The function must also remove vertices assigned to another
// bone, so we need to traverse all the bones
{
   if( pBone==NULL ) return;
   for( int i=0; i<m_model.NumberOfVertices(); i++ ) {
      if( m_SelectArray[i] ) 
         pBone->CV_weight[i] = ( idBone==pBone->Id ? 1.0f : 0.0f );
   };
   if( pBone->children ) AssignVertextToBone( idBone, pBone->children );
   if( pBone->brothers ) AssignVertextToBone( idBone, pBone->brothers );
};

void CAnimFigure::SelectAssigned(int idBone)
// Make the current select for this object the
// same as the assigned vertices to a specific
// bone
{
   tBone *pBone = m_bones.FindBone(idBone,&m_bones.m_Skeleton);
   ASSERT(pBone);
   if( pBone==NULL ) return;
   for( int i=0; i<m_model.NumberOfVertices(); i++ ) {
      m_SelectArray[i] = (pBone->CV_weight[i] > 0.0f);
   };
   SetSelected(TRUE);
   // DEBUG!!
   CString s;
   s = pBone->Name + "\n";
   int cnt=0;
   for( int j=0; j<m_model.NumberOfVertices(); j++ ) {
      if( pBone->CV_weight[j] > 0.0f ) {
         CString tmp;
         tmp.Format("%d",j);
         s += tmp + " ";
         cnt++;
         if( (cnt & 7)==0 ) s += "\n";
         if( cnt>300 ) {
            s += "...and more";
            break;
         };
      };
   };
   AfxMessageBox(s);
};

void CAnimFigure::SelectAssigned(LPCTSTR szBone)
// Make the current select for this object the
// same as the assigned vertices to a specific
// bone
{
   ASSERT(AfxIsValidString(szBone));
   tBone *pBone = m_bones.FindBone(CString(szBone),&m_bones.m_Skeleton);
   ASSERT(pBone);
   if( pBone==NULL ) return;
   SelectAssigned(pBone->Id);
};
