// AnimCamera.cpp: implementation of the CAnimCamera class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CharAnim.h"
#include "AnimCamera.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAnimCamera::CAnimCamera()
{
   m_type = CAMERA;
}

CAnimCamera::~CAnimCamera()
{
}


//////////////////////////////////////////////////////////////////////
// Implementation
//////////////////////////////////////////////////////////////////////

BOOL CAnimCamera::Render( TRenderDef &cfg )
{
   switch( cfg.CurrentView ) {
   case VIEW_BONES:
   case VIEW_VERTEX:
      return TRUE; // don't display
   };
   
   float	x, y, a;

	x = cfg.trans[0];
	y = cfg.trans[1];
	a = cfg.rot[2]/180.0f*PI;

	glColor3f(0.0, 0.0, 1.0);
	glBegin(GL_LINE_STRIP);
	glVertex3f(x-16,y,0);
	glVertex3f(x,y+8,0);
	glVertex3f(x+16,y,0);
	glVertex3f(x,y-8,0);
	glVertex3f(x-16,y,0);
	glVertex3f(x+16,y,0);
	glEnd();

	glBegin(GL_LINE_STRIP);
	glVertex3f(x+48*(float)cos(a+PI/4), y+48*(float)sin(a+PI/4), 0);
	glVertex3f(x, y, 0);
	glVertex3f(x+48*(float)cos(a-PI/4), y+48*(float)sin(a-PI/4), 0);
	glEnd();

   return TRUE;
};
