// AnimBones.h: interface for the CAnimBones class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANIMBONES_H__66BA0414_6761_11D2_80C7_0080AD509054__INCLUDED_)
#define AFX_ANIMBONES_H__66BA0414_6761_11D2_80C7_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AnimObject.h"


typedef struct tagBone {
   long Id;                      // Unique Id of bone
   CString Name;                 // Name of bone
   long Flags;
	//
   tagBone *parent;              // Pointer to parent bone
	tagBone *children;            // Pointer to first child
   tagBone *brothers;            // Pointer to first brother
   //
	tVector	scale;					// Current scale factors
	tVector	rot;						// Current rotation factors
	tVector	trans;					// Current translation factors
	//
   tMatrix  matrix;              // Matrix
   //
   tVector rot_min;
   tVector rot_max;
   //
   float *CV_weight;
} tBone;

class CAnimBones : public CAnimObject  
{
public:
	CAnimBones();
	virtual ~CAnimBones();

// Attributes
public:
   tBone m_Skeleton;       // The actual skeleton
   int   m_Count;          // Number of bones in all
   int   m_SelectedBoneId; // Selected bone ID
   int m_nModelVertices;   // Number of vertices in model

// Implementation
public:
   BOOL LoadBones(LPCTSTR szFilename, int nVertices);
   BOOL Destroy();
   virtual BOOL Render( TRenderDef &cfg );
   virtual BOOL UpdateMatrix( TOOLMODE action, TRenderDef &cfg );
   //
	tBone * FindBone( int Id, tBone *pBone );
   tBone * FindBone( CString &Name, tBone *pBone );
   tBone *GetSelectedBone();
   BOOL GetBones(CStringArray &output, tBone *pBone);
   BOOL GetBones(tBone *output, tBone *pBone);
   //
   virtual long NumberOfFrames() { return FALSE; };
   virtual long NumberOfVertices() { return m_Count*14; };
   virtual long NumberOfTriangles() { return m_Count*8; };
protected:
   virtual BOOL Render( TRenderDef &cfg, tBone *pBone );
   BOOL GetBonesMatrix();
   BOOL GetBonesMatrix(tBone *pBone);

};

#endif // !defined(AFX_ANIMBONES_H__66BA0414_6761_11D2_80C7_0080AD509054__INCLUDED_)
